/* EGESZARM.C -- Egsz szmok tlaga, minimuma, maximuma s rendezse */
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <limits.h>

int getline(char s[],int lim){	/* Sor beolvassa s-be. A hosszt */
	int c,i;					/* adja vissza. */
	for(i=0;i<lim&&(c=getchar())!=EOF&&c!='\n';++i)s[i]=c;
	s[i]='\0';
	while(c!=EOF && c!='\n') c=getchar();
	return(i); }

int egesze(char s[]){
	int i = 0;		/* Indexels. */
	
	/* Az eljel tlpse: */
	if( s[i] == '+' || s[i] == '-') ++i;

	/* Elrelps a kvetkez, els nem numerikus karakterre: */
	while( isdigit(s[i]) ) ++i;

	/* Dnts: */
	if(s[i]==0) return 1;
	else return 0; }

void rendez(int tomb[],int n)		/* Az n elem w egsz tmb nvekv rendezse. */
{	
	int i,j,m,temp;
	for(i=0;i<n-1;++i)
	{
		for(j=i+1, m=i; j<n; ++j) if(tomb[j]<tomb[m]) m=j;
		if(i!=m)
		{	temp=tomb[i];
			tomb[i]=tomb[m];
			tomb[m]=temp;
		} 
	} 
}

#define MAX 100
#define MAXSZAMJEGY 20
void main(void){
	int n=0;					/* A rendezend elemek szma. */
	char sor[MAXSZAMJEGY+1];	/* Input puffer. */
	int szam[MAX];					/* A egsz szmokat trol tmb. */
	int min, max;				/* Minimum, maximum. */
	long osszeg;					/* Az sszeg */
	int i;
	while(n<1||n>MAX){
		printf("\nHany egesz szamot rendezzunk(1-%d)? ",MAX);
		getline(sor,3);
		if(egesze(sor)) n=atoi(sor);}
	printf("\n\nKrem a rendezend szmokat %d s +%d kztt!\n",
			INT_MIN, INT_MAX);
	for(i=0;i<n;i++)
	{
		printf("%4d: ",i+1);
		if(getline(sor,MAXSZAMJEGY)>0 && egesze(sor)) szam[i]=atoi(sor);
		else --i; 
	}
	min=max=szam[0];
	osszeg=0;
	for(i=0;i<n;++i)
	{
		osszeg=osszeg+szam[i];
		if(szam[i]<min) min=szam[i];
		if(szam[i]>max) max=szam[i];
	}
	printf("minimum %8d\n",min);
	printf("maximum %8d\n",max);
	printf("tlag %13.2f\n",(float)osszeg/(float)n);
	
	printf("\nA rendezett szmok:\n");
	rendez(szam,n);
	for(i=0;i<n;i++)printf("%8d",szam[i]);
	printf("\n"); }